/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityHydra;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2470;
import net.minecraft.class_2484;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_6808;
import net.minecraft.class_7151;
import net.minecraft.class_7924;

public class HydraCaveStructure
extends class_3195 {
    public static final Codec<HydraCaveStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)HydraCaveStructure.method_42697((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, HydraCaveStructure::new)).codec();

    protected HydraCaveStructure(class_3195.class_7302 config) {
        super(config);
    }

    protected Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        if (context.comp_566().method_43058() >= (Double)IafCommonConfig.INSTANCE.worldGen.generateHydraCaveChance.getValue()) {
            return Optional.empty();
        }
        class_2470 blockRotation = class_2470.method_16548((class_5819)context.comp_566());
        class_2338 blockPos = this.method_42382(context, blockRotation);
        if (!GenerationConstants.isFarEnoughFromSpawn(blockPos)) {
            return Optional.empty();
        }
        return Optional.of(new class_3195.class_7150(blockPos, collector -> collector.method_35462((class_3443)new HydraCavePiece(0, new class_3341(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260())))));
    }

    public class_7151<?> method_41618() {
        return (class_7151)IafStructureTypes.HYDRA_CAVE.get();
    }

    public static class HydraCavePiece
    extends class_3443 {
        public static final class_2960 HYDRA_CHEST = class_2960.method_43902((String)"iceandfire", (String)"chest/hydra_cave");

        protected HydraCavePiece(int length, class_3341 boundingBox) {
            super((class_3773)IafStructurePieces.HYDRA_CAVE.get(), length, boundingBox);
        }

        public HydraCavePiece(class_6625 context, class_2487 nbt) {
            super((class_3773)IafStructurePieces.HYDRA_CAVE.get(), nbt);
        }

        protected void method_14943(class_6625 context, class_2487 nbt) {
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            int i1 = 8;
            int i2 = i1 - 2;
            int ySize = random.method_43048(2);
            int j = i1 + random.method_43048(2);
            int k = 5 + ySize;
            int l = i1 + random.method_43048(2);
            float f = (float)(j + k + l) * 0.333f + 0.5f;
            for (class_2338 blockpos : class_2338.method_20437((class_2338)pivot.method_10069(-j, -k, -l), (class_2338)pivot.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                boolean isNotInDoorway;
                boolean doorwayX = blockpos.method_10263() >= pivot.method_10263() - 2 + random.method_43048(2) && blockpos.method_10263() <= pivot.method_10263() + 2 + random.method_43048(2);
                boolean doorwayZ = blockpos.method_10260() >= pivot.method_10260() - 2 + random.method_43048(2) && blockpos.method_10260() <= pivot.method_10260() + 2 + random.method_43048(2);
                boolean bl = isNotInDoorway = !doorwayX && !doorwayZ && blockpos.method_10264() > pivot.method_10264() || blockpos.method_10264() > pivot.method_10264() + k - (1 + random.method_43048(2));
                if (!(blockpos.method_10262((class_2382)pivot) <= (double)(f * f))) continue;
                if (!(world.method_8320(pivot).method_26204() instanceof class_2281) && isNotInDoorway) {
                    world.method_8652(blockpos, class_2246.field_10219.method_9564(), 3);
                    if (world.method_8320(pivot.method_10074()).method_26204() == class_2246.field_10219) {
                        world.method_8652(blockpos.method_10074(), class_2246.field_10566.method_9564(), 3);
                    }
                    if (random.method_43048(4) == 0) {
                        world.method_8652(blockpos.method_10084(), class_2246.field_10479.method_9564(), 2);
                    }
                    if (random.method_43048(9) == 0) {
                        world.method_30349().method_30530(class_7924.field_41239).method_40264(class_6808.field_35919).ifPresent(holder -> ((class_2975)holder.comp_349()).method_12862(world, chunkGenerator, random, blockpos.method_10084()));
                    }
                }
                if (blockpos.method_10264() == pivot.method_10264()) {
                    world.method_8652(blockpos, class_2246.field_10219.method_9564(), 3);
                }
                if (blockpos.method_10264() > pivot.method_10264() - 1 || world.method_8320(blockpos).method_26225()) continue;
                world.method_8652(blockpos, class_2246.field_10340.method_9564(), 3);
            }
            ySize = random.method_43048(2);
            j = i2 + random.method_43048(2);
            k = 4 + ySize;
            l = i2 + random.method_43048(2);
            f = (float)(j + k + l) * 0.333f + 0.5f;
            for (class_2338 blockpos : class_2338.method_20437((class_2338)pivot.method_10069(-j, -k, -l), (class_2338)pivot.method_10069(j, k, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                if (!(blockpos.method_10262((class_2382)pivot) <= (double)(f * f)) || blockpos.method_10264() <= pivot.method_10264() || world.method_8320(pivot).method_26204() instanceof class_2281) continue;
                world.method_8652(blockpos, class_2246.field_10124.method_9564(), 3);
            }
            for (class_2338 blockpos : class_2338.method_20437((class_2338)pivot.method_10069(-j, -k, -l), (class_2338)pivot.method_10069(j, k + 8, l)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                if (!(blockpos.method_10262((class_2382)pivot) <= (double)(f * f)) || blockpos.method_10264() != pivot.method_10264()) continue;
                if (random.method_43048(30) == 0 && this.isTouchingAir((class_1936)world, blockpos.method_10084())) {
                    class_2586 class_25862;
                    world.method_8652(blockpos.method_10086(1), (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)GenerationConstants.HORIZONTALS[new Random().nextInt(3)]), 2);
                    if (!(world.method_8320(blockpos.method_10086(1)).method_26204() instanceof class_2281) || !((class_25862 = world.method_8321(blockpos.method_10086(1))) instanceof class_2595)) continue;
                    class_2595 chest = (class_2595)class_25862;
                    chest.method_11285(HYDRA_CHEST, random.method_43055());
                    continue;
                }
                if (random.method_43048(45) == 0 && this.isTouchingAir((class_1936)world, blockpos.method_10084())) {
                    world.method_8652(blockpos.method_10084(), (class_2680)class_2246.field_10481.method_9564().method_11657((class_2769)class_2484.field_11505, (Comparable)Integer.valueOf(random.method_43048(15))), 2);
                    continue;
                }
                if (random.method_43048(35) == 0 && this.isTouchingAir((class_1936)world, blockpos.method_10084())) {
                    world.method_8652(blockpos.method_10084(), (class_2680)class_2246.field_10503.method_9564().method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.valueOf(true)), 2);
                    for (class_2350 facing : class_2350.values()) {
                        if (!(random.method_43057() < 0.3f) || facing == class_2350.field_11033) continue;
                        world.method_8652(blockpos.method_10084().method_10093(facing), class_2246.field_10503.method_9564(), 2);
                    }
                    continue;
                }
                if (random.method_43048(15) == 0 && this.isTouchingAir((class_1936)world, blockpos.method_10084())) {
                    world.method_8652(blockpos.method_10084(), class_2246.field_10214.method_9564(), 2);
                    continue;
                }
                if (random.method_43048(15) != 0 || !this.isTouchingAir((class_1936)world, blockpos.method_10084())) continue;
                world.method_8652(blockpos.method_10084(), random.method_43056() ? class_2246.field_10251.method_9564() : class_2246.field_10559.method_9564(), 2);
            }
            EntityHydra hydra = new EntityHydra((class_1299<EntityHydra>)((class_1299)IafEntities.HYDRA.get()), (class_1937)world.method_8410());
            hydra.setVariant(random.method_43048(3));
            hydra.method_18408(pivot, 15);
            hydra.method_5641((double)pivot.method_10263() + 0.5, (double)pivot.method_10264() + 1.5, (double)pivot.method_10260() + 0.5, random.method_43057() * 360.0f, 0.0f);
            world.method_8649((class_1297)hydra);
        }

        private boolean isTouchingAir(class_1936 worldIn, class_2338 pos) {
            for (class_2350 direction : GenerationConstants.HORIZONTALS) {
                if (worldIn.method_22347(pos.method_10093(direction))) continue;
                return false;
            }
            return true;
        }
    }
}

